﻿using System.Collections;
using System.Collections.Generic;
using Unity.XR.Qiyu;
using UnityEngine;
using UnityEngine.UI;

public class SeethroughTest : MonoBehaviour
{
    public GameObject ground;
    bool isSeeThroughEnbale = false;

    // Start is called before the first frame update
    void Start()
    {
        //set seethrough callback
        QiyuXRCore.RegisterSeeThroughCallback(OnSeeThroughChanged);
        QiyuSeeThrough.EnableSeeThrough(false);
    }

    private void OnDestroy()
    {
        QiyuXRCore.UnRegisterSeeThroughCallback(OnSeeThroughChanged);
    }

    void OnSeeThroughChanged(int state)
    {
        Debug.LogFormat("SeeThrough state changed:{0}", state);

        if (ground)
        {
            ground.SetActive(state == SeeThroughChangeStatus.AppOpen ? false : true);
        }
    }

    public void OnButtonClick(GameObject btn)
    {
        if (btn.name == "Seethrough")
        {
            isSeeThroughEnbale = !isSeeThroughEnbale;
            btn.GetComponentInChildren<Text>().text = string.Format("Seethrough({0})",
                isSeeThroughEnbale ? "on" : "off");
            QiyuSeeThrough.EnableSeeThrough(isSeeThroughEnbale);
        }
    }
}
